/*
 * Decompiled with CFR 0.152.
 */
package screens;

import game.Apearance;
import javax.microedition.lcdui.Graphics;
import lib.Fonts;
import lib.Lib;
import main.GameManager;
import main.MusicManager;
import screens.DialogScreen;
import screens.GetMoreGamesScreen;
import screens.HelpScreen;
import screens.LogoScreen;
import screens.OptionsScreen;
import screens.elements.MenuField;

public class MenuScreen {
    public static int MENU_FIELD_HEIGHT;
    public static int MENU_FIELD_BORDER_COLOR;
    public static int MENU_TEXT_MARGIN;
    public static int MENU_ICONS_POSITION;
    public static int MENU_ANIMATION_BASE_INTERVAL;
    public static int MENU_ANIMATION_OPENING_SPEED;
    public static int MENU_ANIMATION_CLOSING_SPEED;
    public static int MENU_ANIMATION_OPENING_MIN_SPEED;
    public static int MENU_ICONS_ON_SCREEN;
    public static int MENU_ICONS_WIDTH;
    public static int MENU_ICONS_SMALL_WIDTH;
    public static int MENU_ICONS_ANIMATION_SPEED;
    public static int MENU_ICONS_ANIMATION_MIN_SPEED;
    public static int MENU_ARROW_MOVEMENT_SIZE;
    public static int MENU_ARROW_MOVEMENT_STEP;
    public static int MENU_ARROW_SIDE_MARGIN;
    public static int[] TEXT_MENU_MAIN_START;
    public static int[] TEXT_MENU_INSTRUCTIONS;
    public static int[] TEXT_MENU_ABOUT;
    public static int[] TEXT_MENU_EXIT;
    public static int[] TEXT_MENU_CONTINUE;
    public static int[] TEXT_MENU_OPTIONS;
    public static int[] TEXT_MENU_GOTO_MAIN;
    public static int[] TEXT_MENU_ARCADE;
    public static int[] TEXT_MENU_FOTO_DEBUG_1;
    public static int[] TEXT_MENU_FOTO_DEBUG_2;
    public static int[] TEXT_MUSIC_ON;
    public static int[] TEXT_MUSIC_OFF;
    public static int[] TEXT_LANG_EN;
    public static int[] TEXT_LANG_SP;
    public static int[] TEXT_LANG_FR;
    public static int[] TEXT_LANG_IT;
    public static int[] TEXT_LANG_DE;
    public static final int MENU_TYPE_MAIN = 1;
    public static final int MENU_TYPE_INGAME = 2;
    public static final int MENU_TYPE_ENABLE_SOUND = 3;
    public static final int MENU_TYPE_LANGUAGE_SELECT = 4;
    private static int menuTypeCurrent;
    private static int menuTypeRequested;
    public static int itemSelected;
    public static int itemDest;
    private static int itemSelectedRequested;
    private static int[][] items;
    private static int[][] itemsNonWrap;
    private static int[][] items2;
    private static int[] itemsIconIndexes;
    private static int[][] itemsRequested;
    private static int[] itemsIconIndexesRequested;
    public static boolean isAnimationIconsInProgress;
    public static boolean stopMenuAnimation;
    private static int interIcon;
    private static int itemOffset;
    public static int arrowOffset;
    public static int arrowMovementDirection;
    public static int FRAME_COLOR_DARK;
    public static int FRAME_COLOR_STEP;
    public static int frameColor;
    private static int frameColorChangeDirection;
    public boolean isFrameColorAnimating = false;
    public static boolean stopFrameColorAnimation;
    public static int[][] MENU_ITEMS_MAIN;
    public static int[] MENU_ITEMS_MAIN_ICONS_INDEXES;
    public static int[][] MENU_ITEMS_MAIN_WITH_ARCADE;
    public static int[] MENU_ITEMS_MAIN_ARCADE_ICONS_INDEXES;
    public static int[][] MENU_ITEMS_INGAME;
    public static int[] MENU_ITEMS_INGAME_ICONS_INDEXES;
    public static int[][] MENU_ITEMS_ENABLE_SOUND;
    public static int[] MENU_ITEMS_ENABLE_SOUND_ICONS_INDEXES;
    public static int[][] MENU_ITEMS_LANG_MENU;
    public static int[] MENU_ITEMS_LANG_MENU_ICONS_INDEXES;
    public static int[] TEXT_MENU_GET_MORE_GAMES;

    public static void showMainMenu(boolean reset) {
        GameManager.keysBlocked = true;
        if (LogoScreen.imgLogoGame != null) {
            GameManager.imgCurrentImage = LogoScreen.imgLogoGame;
            LogoScreen.imgLogoGame = null;
        } else {
            GameManager.imgCurrentImage = Lib.loadImage("/title.png");
        }
        menuTypeRequested = 1;
        if (GameManager.isContinueIconEnabled) {
            itemsRequested = MENU_ITEMS_MAIN_WITH_ARCADE;
            itemsIconIndexesRequested = MENU_ITEMS_MAIN_ARCADE_ICONS_INDEXES;
        } else {
            itemsRequested = MENU_ITEMS_MAIN;
            itemsIconIndexesRequested = MENU_ITEMS_MAIN_ICONS_INDEXES;
        }
        interIcon = (GameManager.current.getWidth() - MENU_ICONS_WIDTH * MENU_ICONS_ON_SCREEN) / MENU_ICONS_ON_SCREEN;
        DialogScreen.isImageBlured = false;
        if (reset) {
            itemSelectedRequested = 0;
        }
        GameManager.current.startOperation(4, 3);
        GameManager.keysBlocked = false;
    }

    public static void showInGameMain(boolean reset) {
        GameManager.previousScreenStack.addElement(new Integer(GameManager.currentScreen));
        if (reset) {
            itemSelectedRequested = 0;
        }
        menuTypeRequested = 2;
        itemsRequested = MENU_ITEMS_INGAME;
        itemsIconIndexesRequested = MENU_ITEMS_INGAME_ICONS_INDEXES;
        DialogScreen.stopAnimateGame = true;
        GameManager.current.startOperation(4, 3);
    }

    public static void showEnableSound() {
        itemSelectedRequested = MusicManager.isEnabledMusic ? 1 : 0;
        menuTypeRequested = 3;
        itemsRequested = MENU_ITEMS_ENABLE_SOUND;
        itemsIconIndexesRequested = MENU_ITEMS_ENABLE_SOUND_ICONS_INDEXES;
        interIcon = (GameManager.current.getWidth() - GameManager.imgIconsMain.getHeight() * MENU_ICONS_ON_SCREEN) / MENU_ICONS_ON_SCREEN;
        GameManager.current.startOperation(4, 3);
    }

    public static void showLangMenu() {
        MenuScreen.showEnableSound();
    }

    public static void paint_Menu(Graphics g) {
        if (!MenuField.paint_MenuBackground(g)) {
            return;
        }
        int iconX = GameManager.current.getWidth() / 2 - MENU_ICONS_WIDTH / 2;
        int cursorPosY = GameManager.current.getHeight() / 2 - MENU_FIELD_HEIGHT + MENU_ICONS_POSITION;
        int itemOffsetLocal = itemOffset;
        if (menuTypeCurrent != 3) {
            for (int i = -(MENU_ICONS_ON_SCREEN / 2 + 1); i <= MENU_ICONS_ON_SCREEN / 2 + 1; ++i) {
                int iconSmallX = iconX + i * (MENU_ICONS_WIDTH + interIcon) - itemOffsetLocal + (MENU_ICONS_WIDTH - MENU_ICONS_SMALL_WIDTH) / 2;
                int iconSmallY = cursorPosY + (GameManager.imgIconsMain.getHeight() - GameManager.imgIconsSmall.getHeight()) / 2;
                int iconSmallCenterX = iconSmallX + MENU_ICONS_SMALL_WIDTH / 2;
                if (iconSmallCenterX > GameManager.current.getWidth() / 2 - 6 * MENU_ICONS_WIDTH / 10 && iconSmallCenterX < GameManager.current.getWidth() / 2 + 6 * MENU_ICONS_WIDTH / 10) {
                    Lib.drawSprite(g, GameManager.imgIconsMain, iconX + i * (MENU_ICONS_WIDTH + interIcon) - itemOffsetLocal, cursorPosY, MENU_ICONS_WIDTH, GameManager.imgIconsMain.getHeight(), itemsIconIndexes[Lib.mod(i + itemSelected, items.length)] * MENU_ICONS_WIDTH, 0);
                    continue;
                }
                Lib.drawSprite(g, GameManager.imgIconsSmall, iconSmallX, iconSmallY, MENU_ICONS_SMALL_WIDTH, GameManager.imgIconsSmall.getHeight(), itemsIconIndexes[Lib.mod(i + itemSelected, items.length)] * MENU_ICONS_SMALL_WIDTH, 0);
            }
        } else {
            Lib.drawSprite(g, GameManager.imgIconsMain, iconX - itemOffsetLocal, cursorPosY, MENU_ICONS_WIDTH, GameManager.imgIconsMain.getHeight(), itemsIconIndexes[Lib.mod(itemSelected, items.length)] * MENU_ICONS_WIDTH, 0);
        }
        cursorPosY = GameManager.current.getHeight() / 2 + MENU_FIELD_HEIGHT - MENU_TEXT_MARGIN;
        int prevColor = g.getColor();
        g.setColor(Apearance.COLOR_MENU_TEXT);
        if (items2[Lib.mod(itemDest, items.length)] == null || items2[Lib.mod(itemDest, items.length)].length == 0) {
            Fonts.fontMenu.drawString(g, items[Lib.mod(itemDest, items.length)], GameManager.current.getWidth() / 2, cursorPosY, 33);
        } else {
            Fonts.fontMenu.drawString(g, items[Lib.mod(itemDest, items.length)], GameManager.current.getWidth() / 2, cursorPosY - Fonts.fontMenu.getHeight() / 2, 33);
            Fonts.fontMenu.drawString(g, items2[Lib.mod(itemDest, items.length)], GameManager.current.getWidth() / 2, cursorPosY + Fonts.fontMenu.getHeight() / 2, 33);
        }
        g.setColor(prevColor);
        Lib.drawSprite(g, GameManager.imgArrows, 0 + MENU_ARROW_SIDE_MARGIN + arrowOffset, cursorPosY -= Fonts.fontMenu.getHeight() / 2 + GameManager.imgArrows.getHeight() / 4, GameManager.imgArrows.getWidth() / 2, GameManager.imgArrows.getHeight() / 2, 0, 0);
        Lib.drawSprite(g, GameManager.imgArrows, GameManager.current.getWidth() - MENU_ARROW_SIDE_MARGIN - arrowOffset - GameManager.imgArrows.getWidth() / 2, cursorPosY, GameManager.imgArrows.getWidth() / 2, GameManager.imgArrows.getHeight() / 2, GameManager.imgArrows.getWidth() / 2, 0);
        MenuField.drawMenuBorders(g);
    }

    public static void keyPressed_Menu(int key) {
        if (MenuField.isAnimationFieldResizeInProgress) {
            return;
        }
        if (Math.abs(itemSelected - itemDest) >= items.length) {
            return;
        }
        switch (GameManager.current.getGameAction(key)) {
            case 2: {
                if (menuTypeCurrent == 3) {
                    itemDest = --itemSelected;
                    break;
                }
                --itemDest;
                break;
            }
            case 5: {
                if (menuTypeCurrent == 3) {
                    itemDest = ++itemSelected;
                    break;
                }
                ++itemDest;
                break;
            }
            case 8: {
                if (itemSelected != itemDest) break;
                itemDest = itemSelected = Lib.mod(itemSelected, items.length);
                if (itemsNonWrap[itemSelected] == TEXT_MENU_MAIN_START) {
                    DialogScreen.showGameScreen(true);
                    break;
                }
                if (itemsNonWrap[itemSelected] == TEXT_MENU_ARCADE) {
                    DialogScreen.currentClothes = DialogScreen.continueInitialClothes;
                    DialogScreen.showGameScreen(DialogScreen.continueFrameId);
                    break;
                }
                if (itemsNonWrap[itemSelected] == TEXT_MENU_FOTO_DEBUG_1) {
                    DialogScreen.showGameScreen(25);
                    break;
                }
                if (itemsNonWrap[itemSelected] == TEXT_MENU_FOTO_DEBUG_2) {
                    DialogScreen.showGameScreen(94);
                    break;
                }
                if (itemsNonWrap[itemSelected] == TEXT_MENU_CONTINUE) {
                    GameManager.current.startOperation(4, (Integer)GameManager.previousScreenStack.pop());
                    GameManager.current.startOperation(6);
                    break;
                }
                if (itemsNonWrap[itemSelected] == TEXT_MENU_ABOUT) {
                    HelpScreen.showHelpAbout(4);
                    return;
                }
                if (itemsNonWrap[itemSelected] == TEXT_MENU_INSTRUCTIONS) {
                    HelpScreen.showHelpAbout(5);
                    return;
                }
                if (itemsNonWrap[itemSelected] == TEXT_MENU_OPTIONS) {
                    OptionsScreen.showOptions();
                    return;
                }
                if (itemsNonWrap[itemSelected] == TEXT_MENU_GOTO_MAIN) {
                    DialogScreen.closeGame();
                    GameManager.isContinueIconEnabled = false;
                    MenuScreen.showMainMenu(true);
                    break;
                }
                if (itemsNonWrap[itemSelected] == TEXT_MENU_EXIT) {
                    stopMenuAnimation = true;
                    GameManager.current.startOperation(99);
                    return;
                }
                if (itemsNonWrap[itemSelected] == TEXT_MUSIC_OFF) {
                    MusicManager.isEnabledMusic = false;
                    GameManager.gameStarted = true;
                    MenuScreen.showMainMenu(true);
                    break;
                }
                if (itemsNonWrap[itemSelected] == TEXT_MUSIC_ON) {
                    MusicManager.isEnabledMusic = true;
                    GameManager.gameStarted = true;
                    GameManager.current.startOperation(10);
                    MenuScreen.showMainMenu(true);
                    break;
                }
                if (itemsNonWrap[itemSelected] != TEXT_MENU_GET_MORE_GAMES) break;
                if (GetMoreGamesScreen.gmgMenuMode == 1) {
                    GetMoreGamesScreen.invokeGmgWapPage();
                    return;
                }
                if (GetMoreGamesScreen.gmgMenuMode != 2 && GetMoreGamesScreen.gmgMenuMode != 3) break;
                GetMoreGamesScreen.showGmgScreen();
            }
        }
    }

    public static void opAnimateIconsAndArrows() throws InterruptedException {
        if (isAnimationIconsInProgress) {
            return;
        }
        isAnimationIconsInProgress = true;
        arrowMovementDirection = MENU_ARROW_MOVEMENT_STEP;
        arrowOffset = 0;
        stopMenuAnimation = false;
        while (!stopMenuAnimation) {
            if (GameManager.currentScreen == 3 && (itemDest != itemSelected || itemOffset != 0)) {
                int direction = 1;
                if (itemDest != itemSelected) {
                    direction = (itemDest - itemSelected) / Math.abs(itemDest - itemSelected);
                } else if (itemOffset != 0) {
                    direction = -itemOffset / Math.abs(itemOffset);
                }
                int distance = (itemDest - itemSelected) * (MENU_ICONS_WIDTH + interIcon) - itemOffset;
                int step = direction * Math.max(Math.abs(distance / MENU_ICONS_ANIMATION_SPEED), MENU_ICONS_ANIMATION_MIN_SPEED);
                if (Math.abs(itemOffset += step) >= Math.abs(MENU_ICONS_WIDTH + interIcon)) {
                    itemSelected += itemOffset / (MENU_ICONS_WIDTH + interIcon);
                    itemOffset -= itemOffset / (MENU_ICONS_WIDTH + interIcon) * (MENU_ICONS_WIDTH + interIcon);
                    if (itemSelected == itemDest) {
                        itemDest = itemSelected = Lib.mod(itemSelected, items.length);
                        itemOffset = 0;
                    }
                } else if (itemSelected == itemDest && itemOffset * direction > 0) {
                    itemOffset = 0;
                }
            }
            if ((GetMoreGamesScreen.gmgDescOffset += GetMoreGamesScreen.gmgMoveDirectionAndStep) > GetMoreGamesScreen.gmgDescOverHeight / 2 + GetMoreGamesScreen.gmgDescWaitTime * Fonts.fontGMG.getHeight()) {
                GetMoreGamesScreen.gmgDescOffset = -GetMoreGamesScreen.gmgDescOverHeight / 2 - Fonts.fontGMG.getHeight() * 4;
            }
            MenuScreen.opAnimateArrows();
            GameManager.current.repaint();
            Thread.sleep(MENU_ANIMATION_BASE_INTERVAL);
        }
        isAnimationIconsInProgress = false;
        stopMenuAnimation = false;
    }

    public static void opAnimateArrows() {
        frameColor += frameColorChangeDirection;
        if ((arrowOffset += arrowMovementDirection) <= 0 || arrowOffset >= MENU_ARROW_MOVEMENT_SIZE) {
            arrowMovementDirection = -arrowMovementDirection;
            frameColorChangeDirection = -frameColorChangeDirection;
        }
    }

    public static void changeItems() {
        if (itemSelectedRequested >= 0) {
            itemSelected = itemDest = itemSelectedRequested;
            itemSelectedRequested = -1;
        }
        items = new int[itemsRequested.length][];
        items2 = new int[itemsRequested.length][];
        for (int i = 0; i < itemsRequested.length; ++i) {
            int[][] menu_lines = Fonts.fontMenu.wrapString(itemsRequested[i], GameManager.current.getWidth() - MENU_ARROW_MOVEMENT_SIZE * 2 - MENU_ARROW_SIDE_MARGIN * 2 - GameManager.imgArrows.getWidth() - 4, Fonts.SPLIT_CHAR_INT, Fonts.BREAK_LINE_CHAR_INT);
            if (menu_lines.length == 1) {
                MenuScreen.items[i] = menu_lines[0];
                MenuScreen.items2[i] = null;
                continue;
            }
            MenuScreen.items[i] = menu_lines[0];
            MenuScreen.items2[i] = menu_lines[1];
        }
        itemsNonWrap = itemsRequested;
        itemsIconIndexes = itemsIconIndexesRequested;
        menuTypeCurrent = menuTypeRequested;
    }

    static {
        MENU_ICONS_ON_SCREEN = 3;
        MENU_ICONS_ANIMATION_SPEED = 6;
        MENU_ICONS_ANIMATION_MIN_SPEED = 4;
        MENU_ARROW_SIDE_MARGIN = 3;
        menuTypeCurrent = 0;
        menuTypeRequested = 0;
        itemSelected = 0;
        itemDest = 0;
        itemSelectedRequested = -1;
        items = null;
        itemsNonWrap = null;
        items2 = null;
        itemsIconIndexes = null;
        itemsRequested = null;
        itemsIconIndexesRequested = null;
        isAnimationIconsInProgress = false;
        stopMenuAnimation = false;
        itemOffset = 0;
        arrowOffset = 0;
        FRAME_COLOR_DARK = 0x202020;
        FRAME_COLOR_STEP = 0x101010;
        frameColor = FRAME_COLOR_DARK;
        frameColorChangeDirection = FRAME_COLOR_STEP;
        stopFrameColorAnimation = false;
    }
}

